/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.resources;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.lucaargolo.charta.Charta;
import dev.lucaargolo.charta.game.CardDeck;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_1814;
import net.minecraft.class_2960;
import net.minecraft.class_3300;

public class CardDeckResource
implements SimpleSynchronousResourceReloadListener {
    private static final CardDeck MISSING = CardDeck.simple(class_1814.field_8906, false, Charta.MISSING_CARD, Charta.MISSING_CARD);
    private LinkedHashMap<class_2960, CardDeck> decks = new LinkedHashMap();

    public void method_14491(class_3300 manager) {
        this.decks.clear();
        manager.method_14488("decks", id -> id.method_12832().endsWith(".json")).forEach((id, resource) -> {
            try (InputStream stream = resource.method_14482();){
                class_2960 location = id.method_45134(s -> s.replace("decks/", "").replace(".json", ""));
                try (InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);){
                    JsonElement json = JsonParser.parseReader((Reader)reader);
                    DataResult cardDeck = CardDeck.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json);
                    this.decks.put(location, (CardDeck)cardDeck.getOrThrow());
                }
            }
            catch (IOException e) {
                Charta.LOGGER.error("Error while reading deck {} :", id, (Object)e);
            }
        });
        this.decks = this.decks.entrySet().stream().sorted(Comparator.comparing(entry -> ((CardDeck)entry.getValue()).isTradeable()).reversed().thenComparing(entry -> ((CardDeck)entry.getValue()).getRarity().ordinal()).thenComparing(entry -> ((CardDeck)entry.getValue()).getCards().size()).thenComparing(Map.Entry::getKey)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
        Charta.LOGGER.info("Loaded {} decks", (Object)this.decks.size());
    }

    public HashMap<class_2960, CardDeck> getDecks() {
        return this.decks;
    }

    public void setDecks(LinkedHashMap<class_2960, CardDeck> decks) {
        this.decks = decks;
    }

    public CardDeck getDeck(class_2960 id) {
        return this.decks.getOrDefault(id, MISSING);
    }

    public class_2960 getFabricId() {
        return Charta.id("card_decks");
    }
}

